package ru.yandex.direct.ansiblejuggler.model.checks;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ansiblejuggler.model.aggregators.AllChildrenShouldBeOk;

/**
 * Обертка над {@link JugglerCheck} со следующими умолчаниями:
 * <ul>
 * <li>аггрегатор {@link AllChildrenShouldBeOk}</li>
 * <li>флаподавилка выключена</li>
 * </ul>
 */
@ParametersAreNonnullByDefault
public class AllEventsFromAllHostsCheck extends JugglerCheck {
    /**
     * Создать juggler-проверку (без дочерних событий)
     *
     * @param targetHost    результирующий хост
     * @param targetService имя результирующего события
     * @param ttl           TTL проверки
     * @param namespace     имя пространста имен проверки для ограничения доступа
     * @param jcheckMark    метка проверки
     * @throws NullPointerException
     * @throws IllegalArgumentException
     */
    public AllEventsFromAllHostsCheck(String targetHost, String targetService, Duration ttl, String namespace,
                                      String jcheckMark) {
        super(targetHost, targetService, ttl, new AllChildrenShouldBeOk(), namespace, jcheckMark);
    }
}
