package ru.yandex.direct.ansiblejuggler.model.checks;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Параметры флаподавилки
 *
 * @see <a href="https://wiki.yandex-team.ru/sm/juggler/FlapDetector/">обнаружение и подавление флапов</a>
 */
@ParametersAreNonnullByDefault
public class FlapParams {
    @JsonProperty
    private final int stable;

    @JsonProperty
    private final int critical;

    /**
     * Создать параметры флаподавилки
     *
     * @param stable   {@code stable_time} в терминах jctl
     * @param critical {@code critical_time} в терминах jctl
     */
    public FlapParams(int stable, int critical) {
        this.stable = stable;
        this.critical = critical;
    }
}
