package ru.yandex.direct.ansiblejuggler.model.checks;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.direct.ansiblejuggler.PlaybookUtils;

import static ru.yandex.direct.ansiblejuggler.PlaybookUtils.checkChildrenHost;
import static ru.yandex.direct.ansiblejuggler.PlaybookUtils.checkName;

/**
 * Описание дочернего элемента проверок (хост и название исходного события)
 */
@ParametersAreNonnullByDefault
public class JugglerChild {
    private final String name;
    private final String service;

    /**
     * Создать описание
     *
     * @param hostOrCGroup хост или кондукторная группа {@literal CGROUP%group_name}
     *                     валидируется {@link PlaybookUtils#checkChildrenHost(String)}
     * @param service      имя дочернего события
     *                     валидируется {@link PlaybookUtils#checkName(String)}
     */
    public JugglerChild(String hostOrCGroup, String service) {
        checkChildrenHost(hostOrCGroup);
        checkName(service);
        this.name = hostOrCGroup;
        this.service = service;
    }

    @JsonValue
    @Override
    public String toString() {
        return name + ":" + service;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JugglerChild that = (JugglerChild) o;
        return Objects.equals(name, that.name) &&
                Objects.equals(service, that.service);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, service);
    }
}
