package ru.yandex.direct.ansiblejuggler.model.meta;

import java.util.LinkedHashSet;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

@JsonAutoDetect(isGetterVisibility = JsonAutoDetect.Visibility.NONE)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class JugglerMeta {

    @JsonProperty
    private final Set<JugglerMetaUrl> urls;

    public JugglerMeta() {
        this.urls = new LinkedHashSet<>();
    }

    /**
     * Добавить ссылку в мета-информацию.
     *
     * @param url параметры ссылки
     * @throws NullPointerException     если указанная ссылка равна {@code null}
     * @throws IllegalArgumentException если указанная ссылка уже содержится в мета-информации
     */
    public JugglerMeta withUrl(JugglerMetaUrl url) {
        checkNotNull(url, "url cannot be null");
        checkArgument(!this.urls.contains(url), "meta already contains this url");
        urls.add(url);
        return this;
    }
}
