package ru.yandex.direct.ansiblejuggler.model.meta;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import static com.google.common.base.Preconditions.checkNotNull;

public class JugglerMetaUrl {

    @JsonProperty("title")
    private final String title;

    @JsonProperty("url")
    private final String url;

    @JsonProperty("type")
    private final JugglerMetaUrlType type;

    public JugglerMetaUrl(String title, String url, JugglerMetaUrlType type) {
        checkNotNull(title, "title cannot be null");
        checkNotNull(url, "url cannot be null");
        checkNotNull(type, "type cannot be null");
        this.title = title;
        this.url = url;
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JugglerMetaUrl that = (JugglerMetaUrl) o;
        return title.equals(that.title) &&
                url.equals(that.url) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(title, url, type);
    }
}
