package ru.yandex.direct.ansiblejuggler.model.tasks;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ansiblejuggler.model.checks.JugglerCheck;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Описывать задачу с juggler-проверкой
 *
 * @see JugglerCheck
 */
@ParametersAreNonnullByDefault
public class JugglerCheckTask extends JugglerTask {
    @JsonProperty(value = "juggler_check")
    private final String taskName;

    @JsonProperty(value = "args")
    private final JugglerCheck checkParams;

    /**
     * @param taskName    название задачи (для улучшения читаемости плейбука)
     * @param checkParams параметры проверки
     * @throws NullPointerException     если любой из переданных аргументов равен {@code null}
     * @throws IllegalArgumentException если параметры невалидны
     */
    public JugglerCheckTask(String taskName, JugglerCheck checkParams) {
        checkNotNull(taskName);
        this.taskName = taskName;

        checkNotNull(checkParams, "checkParams cannot be null");
        checkArgument(checkParams.isValid(), "invalid checkParams");
        this.checkParams = checkParams;
    }

    /**
     * Создать задачу с проверкой
     *
     * @param checkParams параметры проверки
     * @throws NullPointerException     если параметры равны {@code null}
     * @throws IllegalArgumentException если параметры невалидны
     */
    public JugglerCheckTask(JugglerCheck checkParams) {
        checkNotNull(checkParams, "checkParams cannot be null");
        checkArgument(checkParams.isValid(), "invalid checkParams");
        this.taskName = checkParams.toString();
        this.checkParams = checkParams;
    }
}
