package ru.yandex.direct.ansiblejuggler.model.tasks;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import static ru.yandex.direct.ansiblejuggler.PlaybookUtils.checkJcheckMark;

/**
 * Описывает задачу по очистке устаревших проверок
 */
@ParametersAreNonnullByDefault
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class JugglerCleanupTask extends JugglerTask {
    @JsonProperty
    private final String jugglerCleanup;

    /**
     * Создать задачу по очистке
     *
     * @param jcheckMark метка, для которой требуется удалить отсутствующие (в плейбуке) проверки
     */
    public JugglerCleanupTask(String jcheckMark) {
        checkJcheckMark(jcheckMark);
        jugglerCleanup = "jcheck_mark=" + jcheckMark;
    }
}
