package ru.yandex.direct.ansiblejuggler.model.tasks;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Описывает задачу по настройке плагина ansbile-juggler
 */
@ParametersAreNonnullByDefault
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class JugglerFactsTask extends JugglerTask {
    @JsonProperty
    private final String jugglerFacts;

    /**
     * Создать задачу
     *
     * @param jugglerApiUrl адрес API juggler'а, например {@literal http://dimon.yandex.ru:8998/api}
     */
    public JugglerFactsTask(String jugglerApiUrl) {
        checkNotNull(jugglerApiUrl);
        jugglerFacts = "jserver_api=" + jugglerApiUrl;
    }
}
