package ru.yandex.direct.antifraud.client

import ru.yandex.direct.antifraud.client.model.ChallengeRequestBody
import ru.yandex.direct.asynchttp.ParallelFetcherFactory
import ru.yandex.direct.http.smart.core.Smart
import ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors
import ru.yandex.direct.tvm.TvmIntegration
import ru.yandex.direct.tvm.TvmService

class AntifraudClient(
    parallelFetcherFactory: ParallelFetcherFactory,
    tvmIntegration: TvmIntegration,
    baseUrl: String,
    isProd: Boolean,
) {
    companion object {
        private const val CONSUMER = "direct_phone_verification";
    }

    private val tvmService = if (isProd) TvmService.PASSPORT_ANTIFRAUD_API_PROD else TvmService.PASSPORT_ANTIFRAUD_API_TEST
    private val antifraudApi = Smart.builder()
        .withParallelFetcherFactory(parallelFetcherFactory)
        .withProfileName("antifraud_client")
        .withBaseUrl(baseUrl)
        .useTvm(tvmIntegration, tvmService)
        .build()
        .create(AntifraudApi::class.java)

    fun getVerdict(uid: Long, loginId: String, retpath: String, forceChallenge: Boolean): Verdict {
        val result = antifraudApi.getHost(
            CONSUMER,
            ChallengeRequestBody("challenge", uid, loginId, retpath, forceChallenge)).execute()
        checkResultForErrors(result, ::AntifraudClientException)
        val antifraudResponse = result.success
        return Verdict(antifraudResponse.action, antifraudResponse.tags[0]?.url)
    }
}
