package ru.yandex.direct.appmetrika.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class UniversalCampaignRequest {
    @JsonProperty("campaign_name")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String campaignName;

    @JsonProperty("platforms")
    private UniversalCampaignRequestPlatforms platforms;

    public String getCampaignName() {
        return campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public UniversalCampaignRequestPlatforms getPlatforms() {
        return platforms;
    }

    public void setPlatforms(UniversalCampaignRequestPlatforms platforms) {
        this.platforms = platforms;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public class UniversalCampaignRequestPlatforms {
        @JsonProperty("android")
        private UniversalCampaignRequestPlatformInfo android;

        @JsonProperty("ios")
        private UniversalCampaignRequestPlatformInfo ios;

        public UniversalCampaignRequestPlatformInfo getAndroid() {
            return android;
        }

        public void setAndroid(UniversalCampaignRequestPlatformInfo android) {
            this.android = android;
        }

        public UniversalCampaignRequestPlatformInfo getIos() {
            return ios;
        }

        public void setIos(UniversalCampaignRequestPlatformInfo ios) {
            this.ios = ios;
        }
    }

    public class UniversalCampaignRequestPlatformInfo {
        @JsonProperty("bundle_id")
        private String bundleId;

        public String getBundleId() {
            return bundleId;
        }

        public void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }
    }
}
