package ru.yandex.direct.asynchttp;

import java.util.Set;

import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import static org.asynchttpclient.util.HttpConstants.ResponseStatusCodes.OK_200;

public abstract class AbstractParsableRequest<T> implements ParsableRequest<T> {
    private static final Set<Integer> SUCCESS_RESPONSE_CODES = ImmutableSet.of(
            OK_200, HttpResponseStatus.CREATED.code());

    private long id;
    private final Request request;

    protected AbstractParsableRequest(long id, Request request) {
        this.id = id;
        this.request = request;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public Request getAHCRequest() {
        return request;
    }

    /**
     * @return http-коды, принимаемые обработчиком запросов
     */
    public boolean isParsableResponse(Response response) {
        return response.hasResponseStatus() && SUCCESS_RESPONSE_CODES.contains(response.getStatusCode());
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "Request: " + request.getMethod() + " " + request.getUrl() +
                (request.getStringData() != null ? "\npayload:\n" + request.getStringData() + "\n" : "");
    }
}
