package ru.yandex.direct.asynchttp;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.asynchttpclient.Response;

@ParametersAreNonnullByDefault
public class ErrorResponseWrapperException extends RuntimeException {
    private final Response response;

    public ErrorResponseWrapperException(String message, @Nullable Response response, Throwable cause) {
        super(message, cause);
        this.response = response;
    }

    @Nullable
    public Response getResponse() {
        return response;
    }
}
