package ru.yandex.direct.asynchttp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public class JsonParsableRequest<T> extends AbstractParsableRequest<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper()
            .registerModule(new JavaTimeModule())
            .configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)
            .configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);

    private final Class<T> resultClass;

    public JsonParsableRequest(long id, Request request, Class<T> resultClass) {
        super(id, request);
        this.resultClass = resultClass;
    }

    @Override
    public Function<Response, T> getParseFunction() {
        return response -> {
            String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
            try {
                return OBJECT_MAPPER.readValue(responseBody, resultClass);
            } catch (IOException ex) {
                throw new IllegalArgumentException("can not parse json: " + responseBody, ex);
            }
        };
    }
}
