package ru.yandex.direct.asynchttp;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.asynchttpclient.AsyncHttpClient;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Фабрика фетчеров с общими настройками и общим HTTP-клиентом
 */
@ParametersAreNonnullByDefault
public class ParallelFetcherFactory {
    private final AsyncHttpClient asyncHttpClient;
    private final FetcherSettings defaultFetcherSettings;

    public ParallelFetcherFactory(AsyncHttpClient asyncHttpClient, FetcherSettings fetcherSettings) {
        this.asyncHttpClient = asyncHttpClient;
        this.defaultFetcherSettings = fetcherSettings;
    }

    public <T> ParallelFetcher<T> getParallelFetcher() {
        return getParallelFetcher(defaultFetcherSettings);
    }

    public <T> ParallelFetcher<T> getParallelFetcher(FetcherSettings fetcherSettings) {
        return new ParallelFetcher<>(fetcherSettings, asyncHttpClient);
    }

    /**
     * Создать ParallelFetcher с заданным таимаутом
     */
    public <T> ParallelFetcher<T> getParallelFetcherWithRequestTimeout(Duration timeout) {
        return getParallelFetcher(new FetcherSettings(defaultFetcherSettings).withRequestTimeout(timeout));
    }

    /**
     * Создать ParallelFetcher с кастомным soft-таймаутом
     */
    public <T> ParallelFetcher<T> getParallelFetcherWithSoftTimeout(Duration softTimeout) {
        return getParallelFetcher(new FetcherSettings(defaultFetcherSettings).withSoftTimeout(softTimeout));
    }

    /**
     * Создать ParallelFetcher с заданным числом параллельно выполняемых запросов
     */
    public <T> ParallelFetcher<T> getParallelFetcherWithParallel(int parallel) {
        return getParallelFetcher(new FetcherSettings(defaultFetcherSettings).withParallel(parallel));
    }

    public <T> ParallelFetcher<T> getParallelFetcherWithMetricRegistry(MetricRegistry metricRegistry) {
        return getParallelFetcher((new FetcherSettings(defaultFetcherSettings)
                .withMetricRegistry(metricRegistry)));
    }

    public FetcherSettings defaultSettingsCopy() {
        return new FetcherSettings(defaultFetcherSettings);
    }
}
