package ru.yandex.direct.asynchttp;

import java.util.function.Function;

import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public class ParsableBytesRequest extends AbstractParsableRequest<ParsableBytesRequest.Byteswrapper> {
    public ParsableBytesRequest(long id, Request request) {
        super(id, request);
    }

    @Override
    public Function<Response, Byteswrapper> getParseFunction() {
        return response -> new Byteswrapper().setContent(response.getResponseBodyAsBytes());
    }

    public static class Byteswrapper {
        public byte[] getContent() {
            return content;
        }

        public Byteswrapper setContent(byte[] content) {
            this.content = content;
            return this;
        }

        private byte[] content;
    }
}
