package ru.yandex.direct.asynchttp;

import java.util.function.Function;

import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

import static java.nio.charset.StandardCharsets.UTF_8;

public class ParsableStringRequest extends AbstractParsableRequest<String> {
    public static final long DEFAULT_REQUEST_ID = 1;

    @SuppressWarnings("WeakerAccess")
    public ParsableStringRequest(long id, Request request) {
        super(id, request);
    }

    public ParsableStringRequest(Request request) {
        super(DEFAULT_REQUEST_ID, request);
    }

    @Override
    public Function<Response, String> getParseFunction() {
        return response -> response.getResponseBody(UTF_8); // считаем, что UTF-8 самый правильный вариант
    }

}
