package ru.yandex.direct.asynchttp;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

import org.asynchttpclient.ListenableFuture;

class RequestData<T> {
    private final ParsableRequest<T> request;
    private final Collection<ListenableFuture<?>> calls = new CopyOnWriteArrayList<>();
    private int retries = 0;
    private long softRetryTime = 0;

    RequestData(ParsableRequest<T> req) {
        this.request = req;
    }

    void abort() {
        calls.forEach(call -> call.abort(new RequestExecutionAbortedException()));
    }

    ParsableRequest<T> getRequest() {
        return request;
    }

    void addCall(ListenableFuture<?> call) {
        calls.add(call);
    }

    boolean removeCall(ListenableFuture<?> call) {
        return calls.remove(call);
    }

    int getRelatedCallsInFlyCount() {
        return calls.size();
    }

    long getSoftRetryTimeNanos() {
        return softRetryTime;
    }

    void setSoftRetryTimeNanos(long softRetryTime) {
        this.softRetryTime = softRetryTime;
    }

    int getRetries() {
        return retries;
    }

    void incrementRetries() {
        retries++;
    }

    @Override
    public String toString() {
        return "RequestData{" +
                "retries=" + retries +
                ", request=" + request +
                '}';
    }
}
