package ru.yandex.direct.asynchttp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

@SuppressWarnings("WeakerAccess")
public class Result<T> {
    private final long id;
    private T success;
    private List<Throwable> errors;

    public Result(long id) {
        this.id = id;
    }

    public long getId() {
        return id;
    }

    public void setSuccess(T success) {
        this.success = success;
    }

    public synchronized void addError(Throwable error) {
        if (errors == null) {
            errors = new ArrayList<>();
        }
        errors.add(error);
    }

    public T getSuccess() {
        return success;
    }

    public List<Throwable> getErrors() {
        return errors;
    }

    private static Throwable findSignificantEx(Throwable e) {
        while ((e instanceof ErrorResponseWrapperException || e instanceof ExecutionException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public boolean isTimeout() {
        return errors != null
                && errors.stream().anyMatch(e -> findSignificantEx(e) instanceof TimeoutException);
    }

    @Override
    public String toString() {
        return "Result{" +
                "id=" + getId() +
                ", success=" + success +
                ", errors=" + getErrors() +
                '}';
    }
}
