package ru.yandex.direct.avatars.client;

import org.asynchttpclient.request.body.multipart.PartBase;

import ru.yandex.direct.avatars.client.model.answer.StatusCode;
import ru.yandex.direct.avatars.client.model.answer.UploadImageResponse;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.DELETE;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Multipart;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Part;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;

public interface Api {

    @POST("/put-{namespace}")
    @Multipart
    @Json
    Call<UploadImageResponse> upload(@Path("namespace") String namespace, @Part PartBase imageBody,
                                     @Query("prioritypass") Integer prioritypass);

    @POST("/put-{namespace}/{imagename}")
    @Multipart
    @ResponseHandler(parserClass = UploadImageResponseConverter.class, expectedCodes = {200, 403})
    Call<UploadImageResponse> upload(@Path("namespace") String namespace, @Part PartBase imageBody,
                                     @Path("imagename") String key, @Query("prioritypass") Integer prioritypass);

    @GET("/put-{namespace}/{imagename}")
    @ResponseHandler(parserClass = UploadImageResponseConverter.class, expectedCodes = {200, 403})
    Call<UploadImageResponse> uploadByUrl(@Path("namespace") String namespace, @Path("imagename") String key,
                                          @Query("url") String imageUrl, @Query("prioritypass") Integer prioritypass);

    @DELETE("/delete-{namespace}/{group_id}/{imagename}")
    @ResponseHandler(parserClass = DeleteAvatarsResponseConverter.class, expectedCodes = {200, 202, 404})
    Call<StatusCode> delete(@Path("namespace") String namespace, @Path("group_id") int groupId,
                            @Path("imagename") String key);
}
