package ru.yandex.direct.avatars.client;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

import com.fasterxml.jackson.databind.JavaType;
import org.asynchttpclient.Response;

import ru.yandex.direct.avatars.client.model.answer.UploadImageErrorResponse;
import ru.yandex.direct.avatars.client.model.answer.UploadImageResponse;
import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.direct.utils.JsonUtils;

public class UploadImageResponseConverter implements ResponseConverter<UploadImageResponse> {
    private static final String UPDATE_IS_PROHIBITED = "update is prohibited";

    @Override
    /*
      Если изображение уже загружено, аватарница не даст его обновить.
      Вернется 403 с ошибкой 'update is prohibited', а в  поле 'attrs' информация об изображении.
     */
    public UploadImageResponse convert(Response response, Type responseType) {
        if (response.getStatusCode() == 403) {
            UploadImageErrorResponse uploadImageErrorResponse = convertUploadImageErrorResponse(response);
            if (UPDATE_IS_PROHIBITED.equals(uploadImageErrorResponse.getDescription())) {
                return convertUploadImageResponse(uploadImageErrorResponse.getAttrs());
            }
        }
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
        return convertUploadImageResponse(responseBody);
    }

    private UploadImageErrorResponse convertUploadImageErrorResponse(Response response) {
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
        JavaType javaType = JsonUtils.MAPPER.getTypeFactory().constructType(UploadImageErrorResponse.class);
        return JsonUtils.fromJson(responseBody, javaType);
    }

    private UploadImageResponse convertUploadImageResponse(String attrs) {
        JavaType javaType = JsonUtils.MAPPER.getTypeFactory().constructType(UploadImageResponse.class);
        UploadImageResponse uploadImageResponse = JsonUtils.fromJson(attrs, javaType);
        uploadImageResponse.setMeta(attrs);
        return uploadImageResponse;
    }
}
