package ru.yandex.direct.avatars.client.model;

import java.util.Map;

import ru.yandex.direct.avatars.client.model.answer.ImageSize;

/**
 * Информация об изображении, полученная после загрузки его в аватарницу
 */
public class AvatarInfo {
    /**
     * Неймспейс (конфиг) в аватарнице МДС.
     */
    private final String namespace;
    /**
     * Группа серверов на которых хранится изображение.
     */
    private final int groupId;
    /**
     * Ключ по которому отдаётся изображение.
     * В документации Аватарницы это же поле где-то зовётся именем изображения (imagename),
     * а где-то идентификатором (id).
     */
    private final String key;
    /**
     * Мета-информация об изображении, хранящаяся в аватарнице
     */
    private final String meta;
    /**
     * Размеры ресайзнутых изображений
     */
    private final Map<String, ImageSize> sizes;

    public AvatarInfo(String namespace, int groupId, String key, String meta, Map<String, ImageSize> sizes) {
        this.namespace = namespace;
        this.groupId = groupId;
        this.key = key;
        this.meta = meta;
        this.sizes = sizes;
    }

    public String getNamespace() {
        return namespace;
    }

    public int getGroupId() {
        return groupId;
    }

    public String getKey() {
        return key;
    }

    public String getMeta() {
        return meta;
    }

    public Map<String, ImageSize> getSizes() {
        return sizes;
    }
}
