package ru.yandex.direct.avatars.client.model.answer;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ImageSize {
    @JsonProperty("path")
    private String path;
    @JsonProperty("height")
    private int height;
    @JsonProperty("width")
    private int width;
    @JsonProperty("smart-center")
    private SmartArea smartCenter;
    @JsonProperty("smart-areas")
    private Map<String, SmartArea> smartAreas;
    @JsonProperty("smart-centers")
    private Map<String, SmartArea> smartCenters;

    public String getPath() {
        return path;
    }

    public ImageSize withPath(String path) {
        this.path = path;
        return this;
    }

    public int getHeight() {
        return height;
    }

    public ImageSize withHeight(int height) {
        this.height = height;
        return this;
    }

    public int getWidth() {
        return width;
    }

    public ImageSize withWidth(int width) {
        this.width = width;
        return this;
    }

    public SmartArea getSmartCenter() {
        return smartCenter;
    }

    public ImageSize withSmartCenter(SmartArea smartCenter) {
        this.smartCenter = smartCenter;
        return this;
    }

    public Map<String, SmartArea> getSmartAreas() {
        return smartAreas;
    }

    public ImageSize withSmartAreas(
            Map<String, SmartArea> smartAreas) {
        this.smartAreas = smartAreas;
        return this;
    }

    public Map<String, SmartArea> getSmartCenters() {
        return smartCenters;
    }

    public ImageSize withSmartCenters(
            Map<String, SmartArea> smartCenters) {
        this.smartCenters = smartCenters;
        return this;
    }
}
