package ru.yandex.direct.avatars.config;

import java.time.Duration;

public class AvatarsConfig {
    private final String configName;
    private final ServerConfig readServerConfig;
    private final ServerConfig writeServerConfig;
    private final Duration writeTimeout;
    private final String uploadNamespace;
    private final boolean priorityPass;

    /**
     * @param priorityPass использовать приоритетную квоту
     *                     https://wiki.yandex-team.ru/mds/avatars/#obrabotkaprioritetnyxzaprosov
     */
    public AvatarsConfig(String configName,
                         ServerConfig readServerConfig,
                         ServerConfig writeServerConfig, Duration writeTimeout,
                         String uploadNamespace, boolean priorityPass) {
        this.configName = configName;
        this.readServerConfig = readServerConfig;
        this.writeServerConfig = writeServerConfig;
        this.writeTimeout = writeTimeout;
        this.uploadNamespace = uploadNamespace;
        this.priorityPass = priorityPass;
    }

    public String getConfigName() {
        return configName;
    }

    public ServerConfig getReadServerConfig() {
        return readServerConfig;
    }

    public ServerConfig getWriteServerConfig() {
        return writeServerConfig;
    }

    public String getUploadNamespace() {
        return uploadNamespace;
    }

    public Duration getWriteTimeout() {
        return writeTimeout;
    }

    public boolean getPriorityPass() {
        return priorityPass;
    }
}
