package ru.yandex.direct.balance.client;

import java.net.URL;
import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * В настройках клиента можно задать:
 * - requestTimeout - таимаут на запрос
 * - connectionTimeout - таимаут на ожидание соединения
 * - maxRetries - максимальное количество повторных попыток при ошибках любого рода
 * <p>
 * Плюс, адрес сервера задается в конструкторе
 */
@ParametersAreNonnullByDefault
public class BalanceXmlRpcClientConfig {
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(4);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60);
    private static final int DEFAULT_MAX_RETRIES = 1;

    private URL serverUrl;
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    private int maxRetries = DEFAULT_MAX_RETRIES;

    public BalanceXmlRpcClientConfig(URL serverUrl) {
        this.serverUrl = serverUrl;
    }

    public URL getServerUrl() {
        return serverUrl;
    }

    public Duration getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getMaxRetries() {
        return maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public BalanceXmlRpcClientConfig withConnectionTimeout(final Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public BalanceXmlRpcClientConfig withRequestTimeout(final Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public BalanceXmlRpcClientConfig withMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }
}
