package ru.yandex.direct.balance.client.model.method;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.balance.client.model.response.BalanceBankDescription;
import ru.yandex.direct.utils.JsonUtils;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде объекта
 */
@ParametersAreNonnullByDefault
public class BalanceClassMethodSpec<R> extends BaseBalanceMethodSpec<R> {
    private Class<R> objClass;

    /**
     * @param handleName название метода
     * @param objClass   класс описывающий объект результата.
     *                   Пример: {@link BalanceBankDescription}
     */
    public BalanceClassMethodSpec(String handleName, Class<R> objClass) {
        super(handleName);
        this.objClass = objClass;
    }

    @Override
    public R convertResponse(Object response) {
        return JsonUtils.MAPPER.convertValue(response, objClass);
    }
}
