package ru.yandex.direct.balance.client.model.method;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.balance.client.exception.BalanceClientException;
import ru.yandex.direct.balance.client.model.response.BalanceExtendedStatusResponse;
import ru.yandex.direct.utils.JsonUtils;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде кортежа (0, "SUCCESS", Object)
 */
@ParametersAreNonnullByDefault
public class BalanceExtendedStatusMethodSpec<T> extends BaseBalanceMethodSpec<BalanceExtendedStatusResponse<T>> {
    private final Class<T> objClass;

    /**
     * @param handleName название метода
     * @param objClass   класс описывающий третий элемент кортежа с результатом.
     */
    public BalanceExtendedStatusMethodSpec(String handleName, Class<T> objClass) {
        super(handleName);
        this.objClass = objClass;
    }

    @Override
    public BalanceExtendedStatusResponse<T> convertResponse(Object response) {
        Object[] responseArray = castResponse(response);
        BalanceExtendedStatusResponse<T> mappedResponse =
                new BalanceExtendedStatusResponse<>((int) responseArray[0], (String) responseArray[1]);
        if (mappedResponse.getStatus() != 0) {
            throw new BalanceClientException(
                    String.format("Error balance response status: %s, message: %s", mappedResponse.getStatus(),
                            mappedResponse.getMessage()));
        }
        mappedResponse.setData(JsonUtils.MAPPER.convertValue(responseArray[2], objClass));
        return mappedResponse;
    }
}
