package ru.yandex.direct.balance.client.model.method;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.balance.client.exception.BalanceClientException;
import ru.yandex.direct.balance.client.model.response.BalanceSimpleStatusResponse;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде кортежа (0, "SUCCESS")
 */
@ParametersAreNonnullByDefault
public class BalanceSimpleStatusMethodSpec extends BaseBalanceMethodSpec<BalanceSimpleStatusResponse> {
    public BalanceSimpleStatusMethodSpec(String handleName) {
        super(handleName);
    }

    @Override
    public BalanceSimpleStatusResponse convertResponse(Object response) {
        Object[] tuple = castResponse(response);
        BalanceSimpleStatusResponse statusResponse =
                new BalanceSimpleStatusResponse(castResponse(tuple[0]), castResponse(tuple[1]));
        if (statusResponse.getStatus() != 0) {
            throw new BalanceClientException(
                    String.format("Unexpected status code: %s; message: %s", statusResponse.getStatus(),
                            statusResponse.getMessage()));
        }
        return statusResponse;
    }
}
