package ru.yandex.direct.balance.client.model.method;

import java.io.ByteArrayInputStream;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;

import ru.yandex.direct.balance.client.model.response.LinkedClientsItem;

/**
 * Класс для описания методов XML-RPC API баланса, которые возвращают результат в виде TSV таблицы с заголовком
 */
@ParametersAreNonnullByDefault
public class BalanceTsvMethodSpec<T> extends BaseBalanceMethodSpec<List<T>> {
    private final Class<T> objClass;

    /**
     * @param methodName название метода
     * @param objClass   класс, представляющий описание строки TSV-таблицы.
     *                   Пример: {@link LinkedClientsItem}
     */
    public BalanceTsvMethodSpec(String methodName, Class<T> objClass) {
        super(methodName);
        this.objClass = objClass;
    }

    @Override
    public List<T> convertResponse(Object response) {
        BeanListProcessor<T> rowProcessor = new BeanListProcessor<>(objClass);

        TsvParserSettings parserSettings = new TsvParserSettings();
        parserSettings.getFormat().setLineSeparator("\n");
        parserSettings.setProcessor(rowProcessor);
        parserSettings.setHeaderExtractionEnabled(true);

        TsvParser parser = new TsvParser(parserSettings);

        String stringResponse = castResponse(response);
        parser.parse(new ByteArrayInputStream(stringResponse.getBytes()));

        return rowProcessor.getBeans();
    }
}
