package ru.yandex.direct.balance.client.model.method;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Базовый класс описания метода XML-RPC API баланса.
 * <p>
 * Дает возможность получить имя метода и сконвертировать ответ метода в понятную нам структуру
 */
@ParametersAreNonnullByDefault
public abstract class BaseBalanceMethodSpec<R> {
    private final String handleName;

    public BaseBalanceMethodSpec(String handleName) {
        this.handleName = handleName;
    }

    public String getFullName() {
        return handleName;
    }

    @SuppressWarnings("unchecked")
    static <T> T castResponse(Object response) {
        return (T) response;
    }

    /**
     * Сконвертировать ответ метода, представленный клиентом как Object в объект, с которым можно работать в
     * статически-типизированном мире.
     */
    public abstract R convertResponse(Object response);
}
