package ru.yandex.direct.balance.client.model.request;

import java.time.Duration;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.utils.JsonUtils;

/**
 * Базовый класс, описывающий тело и часть параметров запроса в XML-RPC API баланса.
 * Позволяет задать таимаут ожидания ответа и количество повторов запросов
 */
@ParametersAreNonnullByDefault
public abstract class BalanceRpcRequestParam {
    private Duration timeout;
    private Integer maxRetries;

    protected <T> Map objectToMap(T obj) {
        return JsonUtils.MAPPER.convertValue(obj, Map.class);
    }

    @JsonIgnore
    public Duration getTimeout() {
        return timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @JsonIgnore
    public Integer getMaxRetries() {
        return maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    /**
     * Представить запрос в виде списка объектов для передачи запроса в Баланс
     */
    public abstract Object[] asArray();

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
