package ru.yandex.direct.balance.client.model.request;

import java.time.LocalDate;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;

/**
 * Запрос для создания или обновления существующего клиента. Часть полей может отсутствовать
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createclient
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateClientRequest extends BalanceRpcRequestParam {
    private static final int BALANCE_MAX_PHONE_LENGTH = 255;

    @JsonProperty("CLIENT_ID")
    private String clientId;

    @JsonProperty("CLIENT_TYPE_ID")
    private Integer clientTypeId;

    @JsonProperty("NAME")
    private String name;

    @JsonProperty("EMAIL")
    private String email;

    @JsonProperty("PHONE")
    private String phone;

    @JsonProperty("FAX")
    private String fax;

    @JsonProperty("URL")
    private String url;

    @JsonProperty("CITY")
    private String city;

    @JsonProperty("IS_AGENCY")
    private Boolean isAgency;

    @JsonProperty("AGENCY_ID")
    private Integer agencyId;

    @JsonProperty("REGION_ID")
    private Integer regionId;

    @JsonProperty("SUBREGION_ID")
    private Integer subRegionId;

    @JsonProperty("SERVICE_ID")
    private Integer serviceId;

    @JsonProperty("CURRENCY")
    private String currency;

    @JsonProperty("MIGRATE_TO_CURRENCY")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate migrateToCurrency;

    @JsonProperty("CURRENCY_CONVERT_TYPE")
    private String currencyConvertType;

    @JsonProperty("ONLY_MANUAL_NAME_UPDATE")
    private Boolean onlyManualNameUpdate;

    @JsonIgnore
    private String operatorUid;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
    }

    public Integer getClientTypeId() {
        return clientTypeId;
    }

    public void setClientTypeId(Integer clientTypeId) {
        this.clientTypeId = clientTypeId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        // Баланс не может хранить слишком длинные телефоны
        if (phone != null && phone.length() > BALANCE_MAX_PHONE_LENGTH) {
            throw new IllegalArgumentException("phone: " + phone);
        }
        this.phone = phone;
    }

    public String getFax() {
        return fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Boolean getIsAgency() {
        return isAgency;
    }

    public void setIsAgency(Boolean isAgency) {
        this.isAgency = isAgency;
    }

    public Integer getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Integer agencyId) {
        this.agencyId = agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = Ints.checkedCast(agencyId);
    }

    public Integer getRegionId() {
        return regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public Integer getSubRegionId() {
        return subRegionId;
    }

    public void setSubRegionId(Integer subRegionId) {
        this.subRegionId = subRegionId;
    }

    public Integer getServiceId() {
        return serviceId;
    }

    public void setServiceId(Integer serviceId) {
        this.serviceId = serviceId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public LocalDate getMigrateToCurrency() {
        return migrateToCurrency;
    }

    public void setMigrateToCurrency(LocalDate migrateToCurrency) {
        this.migrateToCurrency = migrateToCurrency;
    }

    public String getCurrencyConvertType() {
        return currencyConvertType;
    }

    public void setCurrencyConvertType(String currencyConvertType) {
        this.currencyConvertType = currencyConvertType;
    }

    public Boolean getOnlyManualNameUpdate() {
        return onlyManualNameUpdate;
    }

    public void setOnlyManualNameUpdate(Boolean onlyManualNameUpdate) {
        this.onlyManualNameUpdate = onlyManualNameUpdate;
    }

    public String getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
    }

    public CreateClientRequest withClientId(final Long clientId) {
        setClientId(clientId);
        return this;
    }

    public CreateClientRequest withClientTypeId(final Integer clientTypeId) {
        this.clientTypeId = clientTypeId;
        return this;
    }

    public CreateClientRequest withName(final String name) {
        this.name = name;
        return this;
    }

    public CreateClientRequest withEmail(final String email) {
        this.email = email;
        return this;
    }

    public CreateClientRequest withPhone(final String phone) {
        setPhone(phone);
        return this;
    }

    public CreateClientRequest withFax(final String fax) {
        this.fax = fax;
        return this;
    }

    public CreateClientRequest withUrl(final String url) {
        this.url = url;
        return this;
    }

    public CreateClientRequest withCity(final String city) {
        this.city = city;
        return this;
    }

    public CreateClientRequest withIsAgency(final Boolean isAgency) {
        this.isAgency = isAgency;
        return this;
    }

    public CreateClientRequest withAgencyId(final Integer agencyId) {
        setAgencyId(agencyId);
        return this;
    }

    public CreateClientRequest withAgencyId(final Long agencyId) {
        setAgencyId(agencyId);
        return this;
    }

    public CreateClientRequest withRegionId(final Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    public CreateClientRequest withSubRegionId(final Integer subRegionId) {
        this.subRegionId = subRegionId;
        return this;
    }

    public CreateClientRequest withServiceId(final Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public CreateClientRequest withCurrency(final String currency) {
        this.currency = currency;
        return this;
    }

    public CreateClientRequest withMigrateToCurrency(final LocalDate migrateToCurrency) {
        this.migrateToCurrency = migrateToCurrency;
        return this;
    }

    public CreateClientRequest withCurrencyConvertType(final String currencyConvertType) {
        this.currencyConvertType = currencyConvertType;
        return this;
    }

    public CreateClientRequest withOnlyManualNameUpdate(final Boolean onlyManualNameUpdate) {
        this.onlyManualNameUpdate = onlyManualNameUpdate;
        return this;
    }

    public CreateClientRequest withOperatorUid(final Long operatorUid) {
        setOperatorUid(operatorUid);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, objectToMap(this)};
    }
}
