package ru.yandex.direct.balance.client.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос для создания счета
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createinvoice
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateInvoiceRequest extends BalanceRpcRequestParam {
    @JsonIgnore
    private Long operatorUid;

    @JsonProperty("RequestID")
    private String requestId;

    @JsonProperty("PaysysID")
    private String paysysId;

    @JsonProperty("PersonID")
    private String personId;

    @JsonProperty("Credit")
    private boolean credit;

    public CreateInvoiceRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public CreateInvoiceRequest withRequestId(Long requestId) {
        this.requestId = requestId.toString();
        return this;
    }

    public CreateInvoiceRequest withPaysysId(Long paysysId) {
        this.paysysId = paysysId.toString();
        return this;
    }

    public CreateInvoiceRequest withPersonId(Long personId) {
        this.personId = personId.toString();
        return this;
    }

    public CreateInvoiceRequest withCredit(boolean credit) {
        this.credit = credit;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }
}
