package ru.yandex.direct.balance.client.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;

import static com.google.common.base.Preconditions.checkArgument;


/**
 * Объект для создания или обновления существующего заказа. Часть полей может отсутствовать
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createorupdateordersbatch
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateOrUpdateOrdersBatchItem {
    public static final int BALANCE_MAX_ORDER_NAME_LENGTH = 255;

    @JsonProperty("ServiceID")
    private Integer serviceId;

    @JsonProperty("ServiceOrderID")
    private Integer serviceOrderId;

    @JsonProperty("ServiceOrderURL")
    private String serviceOrderUrl;

    @JsonProperty("ClientID")
    private String clientId;

    @JsonProperty("AgencyID")
    private Integer agencyId;

    @JsonProperty("subagency_id")
    private Integer subAgencyId;

    @JsonProperty("ContractID")
    private Integer contractId;

    @JsonProperty("ProductID")
    private Integer productId;

    @JsonProperty("Text")
    private String text;

    @JsonProperty("ActText")
    private String actText;

    @JsonProperty("Memo")
    private Integer memo;

    @JsonProperty("ManagerUID")
    private String managerUid;

    @JsonProperty("StartTime")
    private String startTime;

    @JsonProperty("unmoderated")
    private Integer unmoderated;

    @JsonProperty("tag")
    private String tag;

    @JsonProperty("service_product_id")
    private Integer serviceProductId;

    @JsonProperty("RegionID")
    private Integer regionId;

    @JsonProperty("PriceFactor")
    private BigDecimal priceFactor;

    @JsonProperty("DiscardAgencyDiscount")
    private Integer discardAgencyDiscount;

    @JsonProperty("locale")
    private String locale;

    @JsonProperty("GroupServiceOrderID")
    private Integer groupServiceOrderId;

    @JsonProperty("GroupWithoutTransfer")
    private Integer groupWithoutTransfer;

    @JsonProperty("is_ua_optimize")
    private String isUaOptimize;

    @JsonProperty("clid")
    private Integer clId;

    public Integer getServiceId() {
        return serviceId;
    }

    public void setServiceId(Long serviceId) {
        if (serviceId != null) {
            this.serviceId = Ints.checkedCast(serviceId);
        }
    }

    public Integer getServiceOrderId() {
        return serviceOrderId;
    }

    public void setServiceOrderId(Long serviceOrderId) {
        if (serviceOrderId != null) {
            this.serviceOrderId = Ints.checkedCast(serviceOrderId);
        }
    }

    public String getServiceOrderUrl() {
        return serviceOrderUrl;
    }

    public void setServiceOrderUrl(String serviceOrderUrl) {
        this.serviceOrderUrl = serviceOrderUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        if (clientId != null) {
            this.clientId = clientId.toString();
        }
    }

    public Integer getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Long agencyId) {
        if (agencyId != null) {
            this.agencyId = Ints.checkedCast(agencyId);
        }
    }

    public Integer getSubAgencyId() {
        return subAgencyId;
    }

    public void setSubAgencyId(Long subAgencyId) {
        if (subAgencyId != null) {
            this.subAgencyId = Ints.checkedCast(subAgencyId);
        }
    }

    public Integer getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        if (contractId != null) {
            this.contractId = Ints.checkedCast(contractId);
        }
    }

    public Integer getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        if (productId != null) {
            this.productId = Ints.checkedCast(productId);
        }

    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        checkArgument(text.length() <= BALANCE_MAX_ORDER_NAME_LENGTH,
                "Balance order name: " + text + " must be shorter than " + BALANCE_MAX_ORDER_NAME_LENGTH +
                        " characters");
        this.text = text;
    }

    public String getActText() {
        return actText;
    }

    public void setActText(String actText) {
        this.actText = actText;
    }

    public Integer getMemo() {
        return memo;
    }

    public void setMemo(Integer memo) {
        this.memo = memo;
    }

    public String getManagerUid() {
        return managerUid;
    }

    public void setManagerUid(Long managerUid) {
        if (managerUid != null) {
            this.managerUid = managerUid.toString();
        }
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public Integer getUnmoderated() {
        return unmoderated;
    }

    public void setUnmoderated(Integer unmoderated) {
        this.unmoderated = unmoderated;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getServiceProductId() {
        return serviceProductId;
    }

    public void setServiceProductId(Integer serviceProductId) {
        this.serviceProductId = serviceProductId;
    }

    public Integer getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        if (regionId != null) {
            this.regionId = Ints.checkedCast(regionId);
        }
    }

    public BigDecimal getPriceFactor() {
        return priceFactor;
    }

    public void setPriceFactor(BigDecimal priceFactor) {
        this.priceFactor = priceFactor;
    }

    public Integer getDiscardAgencyDiscount() {
        return discardAgencyDiscount;
    }

    public void setDiscardAgencyDiscount(Integer discardAgencyDiscount) {
        this.discardAgencyDiscount = discardAgencyDiscount;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Integer getGroupServiceOrderId() {
        return groupServiceOrderId;
    }

    public void setGroupServiceOrderId(Long groupServiceOrderId) {
        if (groupServiceOrderId != null) {
            this.groupServiceOrderId = Ints.checkedCast(groupServiceOrderId);
        }
    }

    public Integer getGroupWithoutTransfer() {
        return groupWithoutTransfer;
    }

    public void setGroupWithoutTransfer(Integer groupWithoutTransfer) {
        this.groupWithoutTransfer = groupWithoutTransfer;
    }

    public String getIsUaOptimize() {
        return isUaOptimize;
    }

    public void setIsUaOptimize(String isUaOptimize) {
        this.isUaOptimize = isUaOptimize;
    }

    public Integer getClId() {
        return clId;
    }

    public void setClId(Long clId) {
        if (clId != null) {
            this.clId = Ints.checkedCast(clId);
        }
    }
}
