package ru.yandex.direct.balance.client.model.request;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

import static java.util.Collections.emptyList;

/**
 * Запрос для создания или обновления существующего заказа. Часть полей может отсутствовать
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createorupdateordersbatch
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateOrUpdateOrdersBatchRequest extends BalanceRpcRequestParam {
    @JsonIgnore
    private String operatorUid;

    @JsonIgnore
    private List<CreateOrUpdateOrdersBatchItem> items;

    @JsonIgnore
    private String serviceToken;

    public String getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
    }

    public List<CreateOrUpdateOrdersBatchItem> getItems() {
        return items;
    }

    public void setItems(List<CreateOrUpdateOrdersBatchItem> items) {
        this.items = items;
    }

    public String getServiceToken() {
        return serviceToken;
    }

    public void setServiceToken(String serviceToken) {
        this.serviceToken = serviceToken;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, Optional.ofNullable(items).orElse(emptyList()).stream().map(this::objectToMap).toArray(), serviceToken};
    }
}
