package ru.yandex.direct.balance.client.model.request;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос на создание плательщика
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createperson
 */
public class CreatePersonRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Long operatorUid;

    // все поля строчки потому что балансу так нужно
    @JsonProperty("client_id")
    private String clientId;

    @JsonProperty("type")
    private String type;

    @JsonProperty("lname")
    private String lastName;

    @JsonProperty("fname")
    private String firstName;

    @JsonProperty("mname")
    private String middlename;

    @JsonProperty("phone")
    private String phone;

    @JsonProperty("email")
    private String email;

    public CreatePersonRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public CreatePersonRequest withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public CreatePersonRequest withType(String type) {
        this.type = type;
        return this;
    }

    public CreatePersonRequest withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CreatePersonRequest withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public CreatePersonRequest withMiddlename(String middlename) {
        this.middlename = middlename;
        return this;
    }

    public CreatePersonRequest withPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public CreatePersonRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this)};
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreatePersonRequest that = (CreatePersonRequest) o;
        return Objects.equals(operatorUid, that.operatorUid) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(type, that.type) &&
                Objects.equals(lastName, that.lastName) &&
                Objects.equals(firstName, that.firstName) &&
                Objects.equals(middlename, that.middlename) &&
                Objects.equals(phone, that.phone) &&
                Objects.equals(email, that.email);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operatorUid, clientId, type, lastName, firstName, middlename, phone, email);
    }
}
