package ru.yandex.direct.balance.client.model.request;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.emptyList;

/**
 * Запрос на создание "корзины"
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.createrequest2
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreateRequest2Request extends BalanceRpcRequestParam {

    @JsonIgnore
    private List<CreateRequest2Item> items;

    @JsonIgnore
    private String operatorUid;

    @JsonIgnore
    private String clientId;

    @JsonProperty("PromoCode")
    private String promocode;

    @JsonProperty("ForceUnmoderated")
    private boolean forceUnmoderated;

    @JsonProperty("DenyPromocode")
    private boolean denyPromocode;


    public String getOperatorUid() {
        return operatorUid;
    }

    public List<CreateRequest2Item> getItems() {
        return items;
    }

    public CreateRequest2Request withItems(
            List<CreateRequest2Item> items) {
        this.items = items;
        return this;
    }

    public CreateRequest2Request withOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public CreateRequest2Request withClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
        return this;
    }

    public CreateRequest2Request withPromocode(@Nullable String promocode) {
        this.promocode = promocode;
        return this;
    }

    public CreateRequest2Request withForceUnmoderated(boolean forceUnmoderated) {
        this.forceUnmoderated = forceUnmoderated;
        return this;
    }

    public CreateRequest2Request withDenyPromocode(boolean denyPromocode) {
        this.denyPromocode = denyPromocode;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, clientId,
                Optional.ofNullable(items).orElse(emptyList()).stream().map(this::objectToMap).toArray(), objectToMap(this)};
    }
}
