package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Запрос для создания представителя клиента
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.createuserclientassociation
 */
@ParametersAreNonnullByDefault
public class CreateUserClientAssociationRequest extends BalanceRpcRequestParam {
    private String operatorUid;
    private String clientId;
    private String representativeUid;

    public String getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
    }

    public CreateUserClientAssociationRequest withOperatorUid(Long operatorUid) {
        setOperatorUid(operatorUid);
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
    }

    public CreateUserClientAssociationRequest withClientId(Long clientId) {
        setClientId(clientId);
        return this;
    }

    public String getRepresentativeUid() {
        return representativeUid;
    }

    public void setRepresentativeUid(@Nullable Long representativeUid) {
        this.representativeUid = representativeUid == null ? null : representativeUid.toString();
    }

    public CreateUserClientAssociationRequest withRepresentativeUid(Long representativeUid) {
        setRepresentativeUid(representativeUid);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, clientId, representativeUid};
    }
}
