package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.balance.client.model.response.ClientPassportInfo;

/**
 * Запрос на редактирование паспортной информации о клиенте
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.editpassport
 */
@ParametersAreNonnullByDefault
public class EditPassportRequest extends BalanceRpcRequestParam {
    private String operatorUid;
    private String clientUid;
    private ClientPassportInfo clientPassportInfo;

    public String getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
    }

    public EditPassportRequest withOperatorUid(Long operatorUid) {
        setOperatorUid(operatorUid);
        return this;
    }

    public String getClientUid() {
        return clientUid;
    }

    public void setClientUid(@Nullable Long clientUid) {
        this.clientUid = clientUid == null ? null : clientUid.toString();
    }

    public EditPassportRequest withClientUid(Long clientUid) {
        setClientUid(clientUid);
        return this;
    }

    public ClientPassportInfo getClientPassportInfo() {
        return clientPassportInfo;
    }

    public void setClientPassportInfo(ClientPassportInfo clientPassportInfo) {
        this.clientPassportInfo = clientPassportInfo;
    }

    public EditPassportRequest withClientPassportInfo(ClientPassportInfo clientPassportInfo) {
        this.clientPassportInfo = clientPassportInfo;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, clientUid, objectToMap(clientPassportInfo)};
    }
}
