package ru.yandex.direct.balance.client.model.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос на получение данных о банке. Часть полей может отсутствовать
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getbank
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetBankRequest extends SelfMappedBalanceRpcRequest {
    @JsonProperty("Swift")
    private String swift;

    @JsonProperty("Bik")
    private String bik;

    public String getSwift() {
        return swift;
    }

    public void setSwift(String swift) {
        this.swift = swift;
    }

    public GetBankRequest withSwift(String swift) {
        this.swift = swift;
        return this;
    }

    public String getBik() {
        return bik;
    }

    public void setBik(String bik) {
        this.bik = bik;
    }

    public GetBankRequest withBik(String bik) {
        this.bik = bik;
        return this;
    }
}
