package ru.yandex.direct.balance.client.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос для получения формы привязки карты
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getcardbindingurl
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetCardBindingURLRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Long operatorUid;

    @JsonIgnore
    private GetCardBindingURLFormType templateTagItem;

    @JsonProperty("ServiceID")
    private Integer serviceID;

    @JsonProperty("Currency")
    private String currency;

    @JsonProperty("ReturnPath")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String returnPath;

    @JsonProperty("Payload")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String getPayload() {
        return "{\"template\":\"checkout\"}";
    }

    public GetCardBindingURLRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public GetCardBindingURLRequest withServiceID(Integer serviceID) {
        this.serviceID = serviceID;
        return this;
    }

    public GetCardBindingURLRequest withCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public GetCardBindingURLRequest withReturnPath(String returnPath) {
        this.returnPath = returnPath;
        return this;
    }

    public GetCardBindingURLRequest withFormType(GetCardBindingURLFormType templateTagItem) {
        this.templateTagItem = templateTagItem;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), objectToMap(this), objectToMap(templateTagItem)};
    }


    public static class GetCardBindingURLFormType {

        @JsonProperty("template_tag")
        private String templateTag;

        public GetCardBindingURLFormType(boolean isMobile) {
            if (isMobile) {
                this.templateTag = "mobile/form";
            } else {
                this.templateTag = "desktop/form";
            }
        }
    }

}
