package ru.yandex.direct.balance.client.model.request;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class GetClientNdsRequest extends ModulusReminderRequest {
    private int serviceId;

    @JsonProperty("ServiceID")
    public int getServiceId() {
        return serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public GetClientNdsRequest withServiceId(int serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @Override
    public GetClientNdsRequest withModulus(int modulus) {
        setModulus(modulus);
        return this;
    }

    @Override
    public GetClientNdsRequest withReminder(int reminder) {
        setReminder(reminder);
        return this;
    }
}
