package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;

/**
 * Запрос для получения плательщиков клиента
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getclientpersons
 */
public class GetClientPersonsRequest extends BalanceRpcRequestParam {

    private String clientId;

    public GetClientPersonsRequest withClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{clientId};
    }
}
