package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Ints;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Запрос на получение финансовой информации о клиенте
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.getfirmcountrycurrency
 */
@JsonInclude(JsonInclude.Include.NON_NULL)  // Часть полей может отсутствовать
public class GetFirmCountryCurrencyRequest extends SelfMappedBalanceRpcRequest {
    @JsonProperty("client_id")
    private String clientId;

    @JsonProperty("agency_id")
    private Integer agencyId;

    @JsonProperty("region_id")
    private Integer regionId;

    @JsonProperty("service_id")
    private int serviceId;

    @JsonProperty("service_filter")
    private boolean serviceFilter;

    @JsonProperty("currency_filter")
    private boolean currencyFilter;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
    }

    public Integer getAgencyId() {
        return agencyId;
    }

    public void setAgencyId(Integer agencyId) {
        this.agencyId = agencyId;
    }

    public void setAgencyId(Long agencyId) {
        this.agencyId = Ints.checkedCast(agencyId);
    }

    public Integer getRegionId() {
        return regionId;
    }

    public void setRegionId(Integer regionId) {
        this.regionId = regionId;
    }

    public int getServiceId() {
        return serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public boolean isServiceFilter() {
        return serviceFilter;
    }

    public void setServiceFilter(boolean serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public boolean isCurrencyFilter() {
        return currencyFilter;
    }

    public void setCurrencyFilter(boolean currencyFilter) {
        this.currencyFilter = currencyFilter;
    }

    public GetFirmCountryCurrencyRequest withClientId(final Long clientId) {
        setClientId(clientId);
        return this;
    }

    public GetFirmCountryCurrencyRequest withAgencyId(final Integer agencyId) {
        this.agencyId = agencyId;
        return this;
    }

    public GetFirmCountryCurrencyRequest withAgencyId(final Long agencyId) {
        this.agencyId = Ints.checkedCast(agencyId);
        return this;
    }

    public GetFirmCountryCurrencyRequest withRegionId(final Integer regionId) {
        this.regionId = regionId;
        return this;
    }

    public GetFirmCountryCurrencyRequest withServiceId(final Integer serviceId) {
        this.serviceId = checkNotNull(serviceId);
        return this;
    }

    public GetFirmCountryCurrencyRequest withServiceFilter(final boolean serviceFilter) {
        this.serviceFilter = serviceFilter;
        return this;
    }

    public GetFirmCountryCurrencyRequest withCurrencyFilter(final boolean currencyFilter) {
        this.currencyFilter = currencyFilter;
        return this;
    }
}
