package ru.yandex.direct.balance.client.model.request;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Запрос информации о менеджерах
 */
@ParametersAreNonnullByDefault
public class GetManagersInfoRequest extends SelfMappedBalanceRpcRequest {
    private Collection<Long> managerUids;

    public Collection<Long> getManagerUids() {
        return managerUids;
    }

    public void setManagerUids(Collection<Long> managerUids) {
        this.managerUids = managerUids;
    }

    public GetManagersInfoRequest withManagerUids(Collection<Long> managerUids) {
        this.managerUids = managerUids;
        return this;
    }

    @Override
    public Object[] asArray() {
        // id клиентов должны быть уникальными, чтобы не было ошибки при вызове Баланса
        Object[] managerUidsAsStrings = managerUids.stream()
                .distinct()
                .map(Object::toString)
                .toArray();
        return new Object[]{managerUidsAsStrings};
    }
}
