package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Запрос за настройки автоовердрафта
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetOverdraftParamsRequest extends BalanceRpcRequestParam {

    @JsonIgnore
    private Integer serviceId;

    @JsonIgnore
    private String clientId;

    public Integer getServiceId() {
        return serviceId;
    }

    public GetOverdraftParamsRequest withServiceId(Integer serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public GetOverdraftParamsRequest withClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{serviceId, clientId};
    }
}
