package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetPartnerContractsRequest extends SelfMappedBalanceRpcRequest {
    @Nullable
    @JsonProperty("ClientID")
    private final String clientId;

    @Nullable
    @JsonProperty("ExternalID")
    private final String externalContractId;

    public GetPartnerContractsRequest(@Nullable Long clientId, @Nullable String externalContractId) {

        this.clientId = (clientId == null ? null : clientId.toString());
        this.externalContractId = externalContractId;
    }

    @Nullable
    public String getClientId() {
        return clientId;
    }

    @Nullable
    public String getExternalContractId() {
        return externalContractId;
    }

}
