package ru.yandex.direct.balance.client.model.request;

import java.util.Map;

public class GetPassportByUidRequest extends BalanceRpcRequestParam {

    private Long operatorUid;

    private Long uid;

    private Map<String, String> relations;


    public Long getOperatorUid() {
        return operatorUid;
    }

    public GetPassportByUidRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid;
        return this;
    }

    public Long getUid() {
        return uid;
    }

    public GetPassportByUidRequest withUid(Long uid) {
        this.uid = uid;
        return this;
    }

    public Map<String, String> getRelations() {
        return relations;
    }

    public GetPassportByUidRequest withRelations(Map<String, String> relations) {
        this.relations = relations;
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid.toString(), uid.toString(), objectToMap(relations)};
    }

}
