package ru.yandex.direct.balance.client.model.request;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.emptyList;

/**
 * Метод возвращающий способы оплаты
 * <p>
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.getrequestchoices
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GetRequestChoicesRequest extends BalanceRpcRequestParam {

    private static final String EMPTY_REQUEST_ID = "-1";

    private static final int SKIP_TRUST_DEFAULT_VALUE = 1;

    @JsonProperty("OperatorUid")
    private String operatorUid;

    @JsonProperty("RequestID")
    private String requestID = EMPTY_REQUEST_ID;

    @JsonProperty("SkipTrust")
    private int skipTrust = SKIP_TRUST_DEFAULT_VALUE;

    @JsonIgnore
    private String clientId;

    @JsonIgnore
    private List<CreateRequest2Item> items;

    public String getOperatorUid() {
        return operatorUid;
    }

    public GetRequestChoicesRequest withOperatorUid(Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
        return this;
    }

    public String getRequestID() {
        return requestID;
    }

    public GetRequestChoicesRequest withRequestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public List<CreateRequest2Item> getItems() {
        return items;
    }

    public GetRequestChoicesRequest withItems(List<CreateRequest2Item> items) {
        this.items = items;
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public GetRequestChoicesRequest withClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{objectToMap(this), clientId,
                Optional.ofNullable(items).orElse(emptyList()).stream().map(this::objectToMap).toArray()};
    }
}
