package ru.yandex.direct.balance.client.model.request;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Запрос на получение паспортной информации о клиенте
 * <p>
 * https://wiki.yandex-team.ru/balance/xmlrpc/#balance.listclientpassports
 */
@ParametersAreNonnullByDefault
public class ListClientPassportsRequest extends BalanceRpcRequestParam {
    private String operatorUid;
    private String clientId;

    public String getOperatorUid() {
        return operatorUid;
    }

    public void setOperatorUid(@Nullable Long operatorUid) {
        this.operatorUid = operatorUid == null ? null : operatorUid.toString();
    }

    public ListClientPassportsRequest withOperatorUid(Long operatorUid) {
        setOperatorUid(operatorUid);
        return this;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(@Nullable Long clientId) {
        this.clientId = clientId == null ? null : clientId.toString();
    }

    public ListClientPassportsRequest withClientId(Long clientId) {
        setClientId(clientId);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{operatorUid, clientId};
    }
}
