package ru.yandex.direct.balance.client.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Запрос методов платежей доступных пользователю:
 * https://wiki.yandex-team.ru/Balance/XmlRpc/#balance.listpaymentmethodssimple
 */
@SuppressWarnings("WeakerAccess")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListPaymentMethodsSimpleRequest extends BalanceRpcRequestParam {

    @JsonProperty("uid")
    private String uid;

    @JsonProperty("user_ip")
    private String userIp;

    @JsonIgnore
    private String serviceToken;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public ListPaymentMethodsSimpleRequest withUid(Long uid) {
        setUid(uid.toString());
        return this;
    }

    public String getUserIp() {
        return userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public ListPaymentMethodsSimpleRequest withUserIp(String userIp) {
        setUserIp(userIp);
        return this;
    }

    public String getServiceToken() {
        return serviceToken;
    }

    public void setServiceToken(String serviceToken) {
        this.serviceToken = serviceToken;
    }

    public ListPaymentMethodsSimpleRequest withServiceToken(String serviceToken) {
        setServiceToken(serviceToken);
        return this;
    }

    @Override
    public Object[] asArray() {
        return new Object[]{serviceToken, objectToMap(this)};
    }

}
